<?php
if(!function_exists("cost_calculator_row_shortcode"))
{
	function cost_calculator_row_shortcode($atts, $content)
	{
		extract(shortcode_atts(array(
			"top_margin" => "none",
			"el_class" => ""
		), $atts));
		
		$output = '<div class="vc_row wpb_row vc_row-fluid cost-calculator-row' . (!empty($el_class) ? ' ' . esc_attr($el_class) : '') . ($top_margin!="none" ? ' ' . esc_attr($top_margin) : '') . '">' . do_shortcode(shortcode_unautop($content)) . '</div>';
		return $output;
	}
	add_shortcode("vc_row", "cost_calculator_row_shortcode");
}
if(!function_exists("cost_calculator_translateColumnWidthToSpan"))
{
	function cost_calculator_translateColumnWidthToSpan($width) 
	{
		preg_match( '/(\d+)\/(\d+)/', $width, $matches );
		if(!empty($matches))
		{
			$part_x = (int)$matches[1];
			$part_y = (int)$matches[2];
			if($part_x > 0 && $part_y > 0)
			{
				$value = ceil($part_x / $part_y * 12);
				if($value > 0 && $value <= 12)
				{
					$width = 'vc_col-sm-' . $value;
				}
			}
		}

		return $width;
	}
}
if(!function_exists("cost_calculator_column_shortcode"))
{
	function cost_calculator_column_shortcode($atts, $content)
	{
		extract(shortcode_atts(array(
			"width" => "1/1",
			"top_margin" => "none",
			"el_class" => ""
		), $atts));
		$width = cost_calculator_translateColumnWidthToSpan($width);
		$output = '<div class="wpb_column vc_column_container cost-calculator-column ' . esc_attr($width) . (!empty($el_class) ? ' ' . esc_attr($el_class) : '') . ($top_margin!="none" ? ' ' . esc_attr($top_margin) : '') . '"><div class="vc_column-inner"><div class="wpb_wrapper">' . do_shortcode(shortcode_unautop($content)) . '</div></div></div>';
		return $output;
	}
	add_shortcode("vc_column", "cost_calculator_column_shortcode");
}
?>