<?php
//custom post type - services
function cost_calculator_calculations_init()
{
	$labels = array(
		'name' => _x('Calculations', 'post type general name', 'cost-calculator'),
		'singular_name' => _x('Calculation', 'post type singular name', 'cost-calculator'),
		'add_new' => _x('Add New', 'calculations', 'cost-calculator'),
		'add_new_item' => __('Add New Calculation', 'cost-calculator'),
		'edit_item' => __('Edit Calculation', 'cost-calculator'),
		'new_item' => __('New Calculation', 'cost-calculator'),
		'all_items' => __('Calculations', 'cost-calculator'),
		'view_item' => __('View Calculation', 'cost-calculator'),
		'search_items' => __('Search Calculations', 'cost-calculator'),
		'not_found' =>  __('No calculations found', 'cost-calculator'),
		'not_found_in_trash' => __('No calculations found in Trash', 'cost-calculator'), 
		'parent_item_colon' => '',
		'menu_name' => __("Calculations", 'cost-calculator')
	);
	
	$args = array(  
		"labels" => $labels, 
		"public" => false,  
		"show_ui" => true,  
		"capability_type" => "post",
		"menu_position" => 20,
		"menu_icon" => "dashicons-clipboard",
		"hierarchical" => false,
		"rewrite" => array("slug" => "calculations"),
		"supports" => array("title", "editor", "excerpt", "page-attributes") 
	);
	register_post_type("calculations", $args);
	if(isset($_GET["operation"]) && $_GET["operation"]=="cancel_subscription" && !empty($_GET["subscription_id"]))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$stripe_payment->cancelSubscription($_GET["subscription_id"]);
		}
	}
}  
add_action("init", "cost_calculator_calculations_init"); 

//custom sidebars items list
function cost_calculator_calculations_edit_columns($columns)
{
	$columns = array(  
		"cb" => "<input type=\"checkbox\">",  
		"title" => _x('Calculation name', 'post type singular name', 'cost-calculator'),
		"order" =>  _x('Order', 'post type singular name', 'cost-calculator'),
		"date" => __('Date', 'cost-calculator')
	);    

	return $columns;  
}  
add_filter("manage_edit-calculations_columns", "cost_calculator_calculations_edit_columns");

function cost_calculator_calculations_posts_custom_column($column)
{
	global $post;
	switch($column)
	{
		case "order":
			echo get_post($post->ID)->menu_order;
			break;
	}
}
add_action("manage_calculations_posts_custom_column", "cost_calculator_calculations_posts_custom_column");

function cost_calculator_calculations_add_meta_boxes() 
{
	add_meta_box( 
        "cost_calculator_calculations_payments",
        esc_html__("Payments", 'cost-calculator'),
        "cost_calculator_calculations_payments_box",
		"calculations",
		"normal",
		"high"
    );
}
add_action("add_meta_boxes", "cost_calculator_calculations_add_meta_boxes");

function cost_calculator_calculations_payments_box($post)
{
	
	$payment_events = get_post_meta($post->ID, "payment_events", true);
	$checkout_session_url = get_post_meta($post->ID, "checkout_session_url", true);
	$customer_id = get_post_meta($post->ID, "customer_id", true);
	$output = '';
	if(!empty($payment_events) || !empty($customer_id))
	{
		if(!empty($payment_events))
		{
			array_multisort(array_column($payment_events, 'time'), SORT_ASC, $payment_events);
			$last_payment_event = end($payment_events);
			$cost_calculator_options = new QLCostCalculator_Options();
			$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$last_payment_event_object = json_decode($last_payment_event["json"]);
			$payment_intent = $stripe_payment->getPaymentIntent($last_payment_event_object->data->object->id);
			//$current_payment_status = substr($last_payment_event["type"], strrpos($last_payment_event["type"], ".") + 1);
			$mode = get_post_meta($post->ID, "mode", true);
			$output .= '<div class="cost-calculator-payments-container"><p><strong>' . esc_html__("Payment status", 'cost-calculator') . '</strong></p><table class="cost-calculator-payments-details"><tr><td>'. esc_html__("Current payment status", 'cost-calculator') . '</td><td class="'. esc_attr($payment_intent->status) . '"><strong>' . esc_html($payment_intent->status) . '</strong></td></tr><tr><td>'. esc_html__("Mode", 'cost-calculator') . '</td><td><strong>' . ($mode=="payment" ? esc_html__("One time payment", 'cost-calculator') : esc_html(ucfirst($mode))) . '</strong></td></tr></table></div>';
		}
		if(isset($mode) && $mode=="subscription")
		{
			$subscription_events = get_post_meta($post->ID, "subscription_events", true);
			if(!empty($subscription_events))
			{
				array_multisort(array_column($subscription_events, 'time'), SORT_ASC, $subscription_events);
				$last_subscription_event = end($subscription_events);
				$last_subscription_event_object = json_decode($last_subscription_event["json"]);
				$subscription = $stripe_payment->getSubscription($last_subscription_event_object->data->object->id);
				$output .= '<div class="cost-calculator-payments-container"><p><strong>' . esc_html__("Subscription details", 'cost-calculator') . '</strong></p><table class="cost-calculator-payments-details">';
				$output .= '<tr><td>'. esc_html__("Subscription id", 'cost-calculator') . '</td><td>' . esc_html($subscription->id) . '</td></tr>';
				$output .= '<tr><td>'. esc_html__("Subscription status", 'cost-calculator') . '</td><td class="subscription-'. esc_attr($subscription->status) . '">' . esc_html($subscription->status) . '</td></tr>';
				$output .= '<tr><td>'. esc_html__("Subscription interval", 'cost-calculator') . '</td><td>' . esc_html__("Every ", 'cost-calculator') . esc_html($subscription->items->data[0]->price->recurring->interval_count) . " " . esc_html($subscription->items->data[0]->price->recurring->interval) . ($subscription->items->data[0]->price->recurring->interval_count>1 ? esc_html__("s", 'cost-calculator') : "") . '</td></tr>';
				if($subscription->status!="canceled" && $subscription->status!="incomplete_expired")
				{
					$output .= '<tr><td>'. esc_html__("Cancel subscription", 'cost-calculator') . '</td><td><a class="cost-calculator-subscription-cancel-link" href="' . esc_url(add_query_arg(array('operation' => 'cancel_subscription', 'subscription_id' => $subscription->id))) . '">' . esc_html__("Click here to cancel subscription", 'cost-calculator') . '</a></td></tr>';
				}
				$output .= '</table></div>';
				$output .= '<div class="cost-calculator-payments-container"><p><strong>' . esc_html__("Subscription events", 'cost-calculator') . '</strong></p><table class="cost-calculator-payments-details"><thead><tr><th>'. esc_html__("Id", 'cost-calculator') . '</th><th>'. esc_html__("Type", 'cost-calculator') . '</th><th>'. esc_html__("Status", 'cost-calculator') . '</th><th>'. esc_html__("Current period end", 'cost-calculator') . '</th><th>'. esc_html__("Datetime", 'cost-calculator') . '</th><th>'. esc_html__("Detailed information", 'cost-calculator') . '</th></thead><tbody>';
				foreach($subscription_events as $subscription_event)
				{
					$output .= '<tr><td>' . esc_html($subscription_event["id"]) . '</td>
					<td class="subscription-' . esc_attr($subscription_event["status"]) . '">' . esc_html($subscription_event["type"]) . '</td>
					<td class="subscription-' . esc_attr($subscription_event["status"]) . '">' . esc_html($subscription_event["status"]) . '</td>
					<td class="column-datetime">' . date(get_option('date_format'). ' ' . get_option('time_format'), $subscription_event["current_period_end"]) . '</td>
					<td class="column-datetime">' . date(get_option('date_format'). ' ' . get_option('time_format'), $subscription_event["time"]) . '</td>
					<td><code>' . print_r($subscription_event, true) . '</code></td></tr>';
				}
				$output .= '</tbody></table></div>';
			}
		}
		if(!empty($payment_events))
		{
			$output .= '<div class="cost-calculator-payments-container"><p><strong>' . esc_html__("Transaction events", 'cost-calculator') . '</strong></p><table class="cost-calculator-payments-details"><thead><tr><th>'. esc_html__("Id", 'cost-calculator') . '</th><th>'. esc_html__("Type", 'cost-calculator') . '</th><th>'. esc_html__("Amount", 'cost-calculator') . '</th><th>'. esc_html__("Amount received", 'cost-calculator') . '</th><th>'. esc_html__("Currency", 'cost-calculator') . '</th><th>'. esc_html__("Datetime", 'cost-calculator') . '</th><th>'. esc_html__("Detailed information", 'cost-calculator') . '</th></thead><tbody>';
			foreach($payment_events as $payment_event)
			{
				$output .= '<tr><td>' . esc_html($payment_event["id"]) . '</td>
				<td class="' . esc_attr(substr($payment_event["type"], strrpos($payment_event["type"], ".") + 1)) . '">' . esc_html($payment_event["type"]) . '</td>
				<td>' . number_format_i18n($payment_event["amount"]/100, 2) . '</td>
				<td>' . number_format_i18n($payment_event["amount_received"]/100, 2) . '</td>
				<td>' . esc_html($payment_event["currency"]) . '</td>
				<td class="column-datetime">' . date(get_option('date_format'). ' ' . get_option('time_format'), $payment_event["time"]) . '</td>
				<td><code>' . print_r($payment_event, true) . '</code></td></tr>';
			}
			$output .= '</tbody></table></div>';
		}
		if(!empty($customer_id))
		{
			$output .= '<div class="cost-calculator-payments-container"><p><strong>' . esc_html__("Customer", 'cost-calculator') . '</strong></p><table class="cost-calculator-payments-details"><tr><td>'. esc_html__("Customer id", 'cost-calculator') . '</td><td><strong>' . esc_html($customer_id) . '</strong></td></tr></table></div>';
		}
		/*if(!empty($checkout_session_url))
		{
			$output .= '<p><strong>' . esc_html("Checkout", 'cost-calculator') . '</strong></p><table class="cost-calculator-payments-details"><tr><td>'. esc_html("Checkout session", 'cost-calculator') . '</td><td><a href="' . esc_url($checkout_session_url) . '" target="_blank">' . esc_html("Open checkout session window", 'cost-calculator') . '</a></td></tr></table>';
		}*/
	}
	else
	{
		$output .= '<div class="cost-calculator-payments-container"><p>' . esc_html__("Payment details for this calculation are not available!", 'cost-calculator') . '</p></div>';
	}
	echo $output;
}
?>