<?php
function cost_calculator_stripe_actions()
{
	ob_start();
	if(isset($_GET["action"]) && $_GET["action"]=="checkout_session" && !empty($_GET['stripe_checkout_session_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			//default checkout message, when payment success page not set
			if($checkout_session["payment_status"]=="paid")
			{
				echo sprintf(__("<p>Hello %s (%s)!</p><p>Thank you for your payment of %s %s!<br>Payment id: %s<br>Payment mode: %s<br>Payment status: %s<br>Redirecting...", 'cost-calculator'),  esc_html($checkout_session["customer_name"]), esc_html($checkout_session["customer_email"]), number_format_i18n(esc_html($checkout_session["amount_total"])/100, 2), esc_html($checkout_session["currency"]), (!empty($checkout_session["payment_intent"]) ? esc_html($checkout_session["payment_intent"]) : esc_html($checkout_session["subscription"])), ($checkout_session["mode"]=="payment" ? esc_html__("One time payment", 'cost-calculator') : esc_html(ucfirst($checkout_session["mode"]))), esc_html($checkout_session["payment_status"]));
				header("refresh:8; url=" . get_home_url()); 
			}
			else if($checkout_session["payment_status"]=="unpaid")
			{
				echo sprintf(__("<p>Hello %s (%s)!</p><p>Your payment of %s %s has been canceled!<br>Payment mode: %s<br>Payment status: %s<br>If you canceled the payment by mistake, please click <a href=\"%s\">here</a> to return to the checkout page.<br>Otherwise click <a href=\"%s\">here</a> to go back to the homepage.", 'cost-calculator'),  esc_html($checkout_session["customer_name"]), esc_html($checkout_session["customer_email"]), number_format_i18n(esc_html($checkout_session["amount_total"])/100, 2), esc_html($checkout_session["currency"]), ($checkout_session["mode"]=="payment" ? esc_html__("One time payment", 'cost-calculator') : esc_html(ucfirst($checkout_session["mode"]))), esc_html($checkout_session["payment_status"]), esc_url($checkout_session["url"]), esc_url(get_home_url()));
			}
			exit();
		}
	}
	else if(isset($_GET["action"]) && $_GET["action"]=="cancel_subscription" && !empty($_GET['stripe_subscription_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$subscription = $stripe_payment->cancelSubscription($_GET["stripe_subscription_id"]);
			if(!isset($_GET["type"]) || $_GET["type"]!="page")
			{
				if(isset($subscription) && $subscription->status=="canceled")
				{
					$product = $stripe_payment->getProduct($subscription->items->data[0]->plan->product);
					echo sprintf(__("<p>Your request to cancel the subscription has been processed!<br>Current subscription status: %s<br>Subscription amount: %s %s<br>Product: %s<br>Subscription id: %s<br>Redirecting...", 'cost-calculator'), esc_html($subscription->status), number_format_i18n(esc_html($subscription->items->data[0]->price->unit_amount/100, 2)), esc_html($subscription->items->data[0]->price->currency), esc_html($product->name), esc_html($subscription->id));
					header("refresh:8; url=" . get_home_url()); 
				}
				else
				{
					echo sprintf(__("<p>An error occurred while trying to delete the subscription: %s<br>Redirecting...", 'cost-calculator'),  esc_html($_GET['stripe_subscription_id']));
					header("refresh:8; url=" . get_home_url()); 
				}
				exit();
			}
		}
	}
}
add_action("plugins_loaded", "cost_calculator_stripe_actions");

function cost_calculator_stripe_payment_webhook()
{
	if(isset($_GET["action"]) && $_GET["action"]=="payment_webhook")
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		$endpoint_secret = get_option("cost_calculator_stripe_endpoint_secret");
		if($endpoint_secret!=false && !empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$stripe_payment->receiveWebhookEvent($endpoint_secret);
		}
	}
}
add_action("init", "cost_calculator_stripe_payment_webhook");
//add_action("plugins_loaded", "cost_calculator_stripe_payment_webhook");

function cost_calculator_checkout_customer_name()
{
	if(!empty($_GET['stripe_checkout_session_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			return $checkout_session["customer_name"];
		}
	}
}
add_shortcode("cost_calculator_checkout_customer_name", "cost_calculator_checkout_customer_name");

function cost_calculator_checkout_customer_email()
{
	if(!empty($_GET['stripe_checkout_session_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			return $checkout_session["customer_email"];
		}
	}
}
add_shortcode("cost_calculator_checkout_customer_email", "cost_calculator_checkout_customer_email");

function cost_calculator_checkout_payment_id()
{
	if(!empty($_GET['stripe_checkout_session_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			return (!empty($checkout_session["payment_intent"]) ? $checkout_session["payment_intent"] : $checkout_session["subscription"]);
		}
	}
}
add_shortcode("cost_calculator_checkout_payment_id", "cost_calculator_checkout_payment_id");

function cost_calculator_checkout_amount()
{
	if(!empty($_GET['stripe_checkout_session_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			return number_format_i18n($checkout_session["amount_total"]/100, 2);
		}
	}
}
add_shortcode("cost_calculator_checkout_amount", "cost_calculator_checkout_amount");

function cost_calculator_checkout_currency()
{
	if(!empty($_GET['stripe_checkout_session_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			return $checkout_session["currency"];
		}
	}
}
add_shortcode("cost_calculator_checkout_currency", "cost_calculator_checkout_currency");

function cost_calculator_checkout_mode()
{
	if(!empty($_GET['stripe_checkout_session_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			return ($checkout_session["mode"]=="payment" ? esc_html__("One time payment", 'cost-calculator') : ucfirst($checkout_session["mode"]));
		}
	}
}
add_shortcode("cost_calculator_checkout_mode", "cost_calculator_checkout_mode");

function cost_calculator_checkout_link($atts)
{
	if(!empty($_GET['stripe_checkout_session_id']))
	{
		extract(shortcode_atts(array(
			"text" => __("here", 'cost-calculator'),
			"title" => __("Return to the checkout page", 'cost-calculator')
		), $atts));
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			return '<a href="' . esc_url($checkout_session["url"]) . '" title="' . esc_attr($title) . '">' . esc_html($text) . '</a>';
		}
	}
}
add_shortcode("cost_calculator_checkout_link", "cost_calculator_checkout_link");

function cost_calculator_checkout_status()
{
	if(!empty($_GET['stripe_checkout_session_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$checkout_session = $stripe_payment->getCheckoutSession($_GET['stripe_checkout_session_id'], $_GET["status"]);
			return $checkout_session["payment_status"];
		}
	}
}
add_shortcode("cost_calculator_checkout_status", "cost_calculator_checkout_status");

function cost_calculator_subscription_id()
{
	if(!empty($_GET['stripe_subscription_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$subscription = $stripe_payment->getSubscription($_GET['stripe_subscription_id']);
			return $subscription->id;
		}
	}
}
add_shortcode("cost_calculator_subscription_id", "cost_calculator_subscription_id");

function cost_calculator_subscription_status()
{
	if(!empty($_GET['stripe_subscription_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$subscription = $stripe_payment->getSubscription($_GET['stripe_subscription_id']);
			return $subscription->status;
		}
	}
}
add_shortcode("cost_calculator_subscription_status", "cost_calculator_subscription_status");

function cost_calculator_subscription_amount()
{
	if(!empty($_GET['stripe_subscription_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$subscription = $stripe_payment->getSubscription($_GET['stripe_subscription_id']);
			return number_format_i18n($subscription->items->data[0]->price->unit_amount/100, 2);
		}
	}
}
add_shortcode("cost_calculator_subscription_amount", "cost_calculator_subscription_amount");

function cost_calculator_subscription_currency()
{
	if(!empty($_GET['stripe_subscription_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$subscription = $stripe_payment->getSubscription($_GET['stripe_subscription_id']);
			return $subscription->items->data[0]->price->currency;
		}
	}
}
add_shortcode("cost_calculator_subscription_currency", "cost_calculator_subscription_currency");

function cost_calculator_subscription_product()
{
	if(!empty($_GET['stripe_subscription_id']))
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		if(!empty($cost_calculator_payments_options["stripe_api_secret_key"]))
		{
			$stripe_payment = new QLCostCalculator_StripePayment($cost_calculator_payments_options["stripe_api_secret_key"]);
			$subscription = $stripe_payment->getSubscription($_GET['stripe_subscription_id']);
			$product = $stripe_payment->getProduct($subscription->items->data[0]->plan->product);
			return $product->name;
		}
	}
}
add_shortcode("cost_calculator_subscription_product", "cost_calculator_subscription_product");
?>