<?php
function cost_calculator_elementor_enqueue_styles_admin()
{
	wp_enqueue_style("cost-calculator-admin-style-elementor", plugins_url('admin/style/elementor.css', __FILE__));
	wp_enqueue_style("cost-calculator-widget-icons-elementor", plugins_url('admin/fonts/widget-icons/style.css', __FILE__));
}
add_action('elementor/editor/before_enqueue_styles', 'cost_calculator_elementor_enqueue_styles_admin');
function cost_calculator_elementor_before_enqueue_scripts()
{
	wp_enqueue_script("cost_calculator_elementor_script", plugins_url('js/elementor.js', __FILE__), array("jquery"), false, true);
}
add_action('elementor/editor/before_enqueue_scripts', "cost_calculator_elementor_before_enqueue_scripts");
if(class_exists("Elementor\Core\Modules_Manager"))
{
	function cost_calculator_add_elementor_widget_categories($elements_manager)
	{
		$categories = [];
		$categories['ql_cost_calculator_main'] =
		[
			'title' => esc_html__("Cost Calculator Main", 'cost-calculator'),
			'icon'  => 'fa fa-plug'
		];
		$categories['ql_cost_calculator_widgets'] =
		[
			'title' => esc_html__("Cost Calculator Widgets", 'cost-calculator'),
			'icon'  => 'fa fa-plug'
		];

		$old_categories = $elements_manager->get_categories();
		$categories = array_merge($categories, $old_categories);

		$set_categories = function ($categories)
		{
			$this->categories = $categories;
		};

		$set_categories->call($elements_manager, $categories);
	}
	add_action('elementor/elements/categories_registered', 'cost_calculator_add_elementor_widget_categories');
	
	function cost_calculator_register_elementor_widgets($widgets_manager) 
	{
		$widgets_manager->register(new \QLCostCalculator_DropdownBox());
		$widgets_manager->register(new \QLCostCalculator_SliderBox());
		$widgets_manager->register(new \QLCostCalculator_InputBox());
		$widgets_manager->register(new \QLCostCalculator_SwitchBox());
		$widgets_manager->register(new \QLCostCalculator_SummaryBox());
		$widgets_manager->register(new \QLCostCalculator_ContactBox());
		$widgets_manager->register(new \QLCostCalculator_CostCalculator());
		$widgets_manager->register(new \QLCostCalculator_Form());
	}
	add_action('elementor/widgets/register', 'cost_calculator_register_elementor_widgets');
}
?>