<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class QLCostCalculator_SwitchBox extends Widget_Base 
{

	public function get_name()
	{
		return 'cost_calculator_switch_box';
	}

	public function get_title()
	{
		return esc_html__("Cost Calculator Switch Box", 'cost-calculator');
	}

	public function get_icon()
	{
		return 'widget-icons-switch-box';
	}

	public function get_categories()
	{
		return ['ql_cost_calculator_widgets'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'cost-calculator'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'switch_box_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'cost-calculator'),
				'default' => 'switch-box',
				'description' => esc_html__("Please provide unique id for each 'Cost Calculator Switch Box' on your page.", 'cost-calculator')
			]
		);
		$this->add_control(
			'name',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Input name", 'cost-calculator'),
				'default' => 'switch-box'
			]
		);
		$this->add_control(
			'label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Label", 'cost-calculator')
			]
		);
		$this->add_control(
			'hide_label',
			[
				'label' => esc_html__("Hide label", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '',
				'description' => esc_html__("Set to 'Yes' if you won't like to display label in the frontend but you still like to receive field value via email", 'cost-calculator'),
			]
		);
		$this->add_control(
			'yes_text',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("'Yes' text", 'cost-calculator'),
				'default' => esc_html__("Yes", 'cost-calculator')
			]
		);
		$this->add_control(
			'no_text',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("'No' text", 'cost-calculator'),
				'default' => esc_html__("No", 'cost-calculator')
			]
		);
		$this->add_control(
			'default_value',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Default value", 'cost-calculator'),
				'default' => "1"
			]
		);
		$this->add_control(
			'checked',
			[
				'label' => esc_html__("Is checked", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '1'
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["switch_box_id"]))
		{
			$settings["id"] = $settings["switch_box_id"];
		}
		echo cost_calculator_switch_box_shortcode($settings);
	}

	protected function content_template(){}
}
?>
