<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class QLCostCalculator_SummaryBox extends Widget_Base 
{

	public function get_name()
	{
		return 'cost_calculator_summary_box';
	}

	public function get_title()
	{
		return esc_html__("Cost Calculator Summary Box", 'cost-calculator');
	}

	public function get_icon()
	{
		return 'eicon-product-price';
	}

	public function get_categories()
	{
		return ['ql_cost_calculator_widgets'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'cost-calculator'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'summary_box_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'cost-calculator'),
				'default' => 'cost',
				'description' => esc_html__("Please provide unique id for each 'Cost calculator summary box' on your page.", 'cost-calculator')
			]
		);
		$this->add_control(
			'name',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Input name", 'cost-calculator'),
				'default' => 'total_cost'
			]
		);
		$this->add_control(
			'formula',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Summary formula", 'cost-calculator'),
				'label_block' => true,
				'description' => esc_html__("Please put here the calculation formula for your form using the form elements ids. Available operators: + {-} * / ( ) {powerstart} ^ {powerend}. Example: square-feet*walls+square-feet*floors{-}20", 'cost-calculator')
			]
		);
		$this->add_control(
			'currency',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Currency sign before value", 'cost-calculator'),
				'default' => '$',
				'description' => esc_html__("Use &amp;space; to display empty space", 'cost-calculator')
			]
		);
		$this->add_control(
			'currency_after',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Currency sign afer value", 'cost-calculator'),
				'description' => esc_html__("Use &amp;space; to display empty space", 'cost-calculator')
			]
		);
		$this->add_control(
			'currency_size',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Currency size", 'cost-calculator'),
				'options' => [
					'default' => esc_html__("Default", 'cost-calculator'),
					'small' => esc_html__("Small", 'cost-calculator')
				],
				'default' => 'default'
			]
		);
		$this->add_control(
			'currency_align',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Currency before vertical align", 'cost-calculator'),
				'options' => [
					'top' => esc_html__("Top", 'cost-calculator'),
					'bottom' => esc_html__("Bottom", 'cost-calculator')
				],
				'default' => 'top',
				'condition' => [
					'currency_size' => 'small'
				]
			]
		);
		$this->add_control(
			'currency_after_align',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Currency after vertical align", 'cost-calculator'),
				'options' => [
					'top' => esc_html__("Top", 'cost-calculator'),
					'bottom' => esc_html__("Bottom", 'cost-calculator')
				],
				'default' => 'bottom',
				'condition' => [
					'currency_size' => 'small'
				]
			]
		);
		$this->add_control(
			'thousands_separator',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Thousands separator", 'cost-calculator'),
				'default' => ','
			]
		);
		$this->add_control(
			'decimal_separator',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Decimal separator", 'cost-calculator'),
				'default' => '.'
			]
		);
		$this->add_control(
			'decimal_places',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Decimal places", 'cost-calculator'),
				'default' => "2"
			]
		);
		$this->add_control(
			'math_function',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Additional math function", 'cost-calculator'),
				'options' => [
					'' => esc_html__("None", 'cost-calculator'),
					'ceil' => esc_html__("Ceil", 'cost-calculator'),
					'floor' => esc_html__("Floor", 'cost-calculator'),
					'abs' => esc_html__("Abs", 'cost-calculator')
				]
			]
		);
		$this->add_control(
			'not_number',
			[
				'label' => esc_html__("Display not number result as 0", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '1'
			]
		);
		$this->add_control(
			'negative',
			[
				'label' => esc_html__("Display negative result as 0", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => ''
			]
		);
		$this->add_control(
			'description',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Description", 'cost-calculator')
			]
		);
		$this->add_control(
			'icon',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Icon", 'cost-calculator'),
				'options' => [
					'' => esc_html__("none", 'cost-calculator'),
					'cc-template-calculation' => esc_html__("calculation", 'cost-calculator'),
					'cc-template-card' => esc_html__("credit card", 'cost-calculator'),
					'cc-template-wallet' => esc_html__("wallet", 'cost-calculator')
				]
			]
		);
		$this->add_control(
			'label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Label", 'cost-calculator'),
				'default' => esc_html__("Total cost: ", 'cost-calculator'),
				'description' => esc_html__("Label for summary value displayed in the email message", 'cost-calculator')
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["summary_box_id"]))
		{
			$settings["id"] = $settings["summary_box_id"];
		}
		if((int)\Elementor\Plugin::$instance->editor->is_edit_mode())
		{
			$settings["is_elementor_edit_mode"] = 1;
		}
		echo cost_calculator_summary_box_shortcode($settings);
	}

	protected function content_template(){}
}
?>
