<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class QLCostCalculator_SliderBox extends Widget_Base 
{

	public function get_name()
	{
		return 'cost_calculator_slider_box';
	}

	public function get_title()
	{
		return esc_html__("Cost Calculator Slider Box", 'cost-calculator');
	}

	public function get_icon()
	{
		return 'widget-icons-slider-box';
	}

	public function get_categories()
	{
		return ['ql_cost_calculator_widgets'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'cost-calculator'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'slider_box_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'cost-calculator'),
				'default' => 'slider-box',
				'description' => esc_html__("Please provide unique id for each 'Cost Calculator Slider Box' on your page.", 'cost-calculator')
			]
		);
		$this->add_control(
			'name',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Input name", 'cost-calculator'),
				'default' => 'slider-box'
			]
		);
		$this->add_control(
			'label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Label", 'cost-calculator')
			]
		);
		$this->add_control(
			'hide_label',
			[
				'label' => esc_html__("Hide label", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => 1,
				'default' => '',
				'description' => esc_html__("Set to 'Yes' if you won't like to display label in the frontend but you still like to receive field value via email", 'cost-calculator')
			]
		);
		$this->add_control(
			'default_value',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Default value", 'cost-calculator'),
				'default' => "6"
			]
		);
		$this->add_control(
			'unit_value',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Unit value", 'cost-calculator'),
				'default' => "1"
			]
		);
		$this->add_control(
			'step',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Step", 'cost-calculator'),
				'default' => 1,
				'min' => 0
			]
		);
		$this->add_control(
			'min',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Min value", 'cost-calculator'),
				'default' => 0
			]
		);
		$this->add_control(
			'max',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__("Max value", 'cost-calculator'),
				'default' => 10
			]
		);
		$this->add_control(
			'minmax_label',
			[
				'label' => esc_html__("Show min-max label", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => 1,
				'default' => ''
			]
		);
		$this->add_control(
			'currency',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Currency sign before value", 'cost-calculator'),
				'description' => esc_html__("Use &amp;space; to display empty space", 'cost-calculator')
			]
		);
		$this->add_control(
			'currency_after',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Currency sign afer value", 'cost-calculator'),
				'description' => esc_html__("Use &amp;space; to display empty space", 'cost-calculator')
			]
		);
		$this->add_control(
			'thousands_separator',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Thousands separator", 'cost-calculator')
			]
		);
		$this->add_control(
			'input_field',
			[
				'label' => esc_html__("Show input field", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => 1,
				'default' => 1
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["slider_box_id"]))
		{
			$settings["id"] = $settings["slider_box_id"];
		}
		echo cost_calculator_slider_box_shortcode($settings);
	}

	protected function content_template(){}
}
?>
