<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class QLCostCalculator_InputBox extends Widget_Base 
{

	public function get_name()
	{
		return 'cost_calculator_input_box';
	}

	public function get_title()
	{
		return esc_html__("Cost Calculator Input Box", 'cost-calculator');
	}

	public function get_icon()
	{
		return 'eicon-text-field';
	}

	public function get_categories()
	{
		return ['ql_cost_calculator_widgets'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'cost-calculator'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'input_box_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'cost-calculator'),
				'default' => 'input-box',
				'description' => esc_html__("Please provide unique id for each 'Cost Calculator Input Box' on your page.", 'cost-calculator')
			]
		);
		$this->add_control(
			'name',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Input name", 'cost-calculator'),
				'default' => 'input-box'
			]
		);
		$this->add_control(
			'type',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Type", 'cost-calculator'),
				'options' => [
					'text' => esc_html__("text", 'cost-calculator'),
					'number' => esc_html__("number", 'cost-calculator'),
					'date' => esc_html__("date", 'cost-calculator'),
					'email' => esc_html__("email", 'cost-calculator'),
					'checkbox' => esc_html__("checkbox", 'cost-calculator'),
					'radio' => esc_html__("radio", 'cost-calculator'),
					'hidden' => esc_html__("hidden", 'cost-calculator'),
					'submit' => esc_html__("submit", 'cost-calculator')
				],
				'default' => 'text'
			]
		);
		$this->add_control(
			'label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Label", 'cost-calculator')
			]
		);
		$this->add_control(
			'hide_label',
			[
				'label' => esc_html__("Hide label", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '',
				'description' => esc_html__("Set to 'Yes' if you won't like to display label in the frontend but you still like to receive field value via email", 'cost-calculator'),
				'condition' => [
					'type' => ['text', 'number', 'date', 'email']
				]
			]
		);
		$this->add_control(
			'group_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Group label", 'cost-calculator'),
				'condition' => [
					'type' => 'radio'
				]
			]
		);
		$this->add_control(
			'default_value',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Default value", 'cost-calculator')
			]
		);
		$this->add_control(
			'checked',
			[
				'label' => esc_html__("Is checked", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '',
				'condition' => [
					'type' => ['checkbox', 'radio']
				]
			]
		);
		$this->add_control(
			'checkbox_type',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Checkbox type", 'cost-calculator'),
				'options' => [
					'type-button' => esc_html__("Button", 'cost-calculator'),
					'default' => esc_html__("Default", 'cost-calculator')
				],
				'default' => 'type-button',
				'condition' => [
					'type' => 'checkbox'
				]
			]
		);
		$this->add_control(
			'checkbox_yes',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Checked hidden text", 'cost-calculator'),
				'default' => esc_html__("checked", 'cost-calculator'),
				'condition' => [
					'type' => 'checkbox'
				]
			]
		);
		$this->add_control(
			'checkbox_no',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Not checked hidden text", 'cost-calculator'),
				'default' => esc_html__("not checked", 'cost-calculator'),
				'condition' => [
					'type' => 'checkbox'
				]
			]
		);
		$this->add_control(
			'placeholder',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Placeholder", 'cost-calculator')
			]
		);
		$this->add_control(
			'required',
			[
				'label' => esc_html__("Required", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '',
				'condition' => [
					'type' => ['text', 'number', 'date', 'email', 'checkbox']
				]
			]
		);
		$this->add_control(
			'required_message',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Required field message", 'cost-calculator'),
				'default' => esc_html__("This field is required", 'cost-calculator'),
				'condition' => [
					'required' => '1'
				]
			]
		);
		$this->add_control(
			'after_pseudo',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("After pseudo element css class", 'cost-calculator')
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["input_box_id"]))
		{
			$settings["id"] = $settings["input_box_id"];
		}
		echo cost_calculator_input_box_shortcode($settings);
	}

	protected function content_template(){}
}
?>
