<?php
use Elementor\Controls_Manager;
use Elementor\Modules\NestedElements\Base\Widget_Nested_Base;

class QLCostCalculator_Form extends Widget_Nested_Base
{
	
	public function get_name()
	{
		return 'ql_cost_calculator_form';
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	public function get_categories()
	{
		return ['ql_cost_calculator_main'];
	}
	
	public function get_title()
	{
		return esc_html__("Cost Calculator Form", 'cost-calculator');
	}

	public function get_icon() 
	{
		return 'eicon-container';
	}	

	protected function get_default_children_elements()
	{
		return [
			[
				'elType' => 'container',
				'settings' => [
					'content_width' => 'full',
				]
			]
		];
	}

	protected function get_default_repeater_title_setting_key()
	{
		return null;
	}

	protected function get_default_children_placeholder_selector()
	{
		return '.cost-calculator-container';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'cost-calculator'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'cost_calculator_id',
			[
				'type' => \Elementor\Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'cost-calculator'),
				'label_block' => false,
				'default' => "cost-calculator-form",
				'description' => esc_html__("Please provide unique id for each cost calculator on the same page/post", 'cost-calculator')
			]
		);
		$this->add_control(
			'form_action_url',
			[
				'type' => \Elementor\Controls_Manager::TEXT,
				'label' => esc_html__("Form action url", 'cost-calculator'),
				'label_block' => false,
				'default' => "#"
			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{		
		$settings = $this->get_settings_for_display();
		echo '<form' . (!empty($settings["cost_calculator_id"]) ? ' id="' . esc_attr($settings["cost_calculator_id"]) . '"' : '') . ' action="' . (isset($settings["form_action_url"]) && $settings["form_action_url"]!="" && $settings["form_action_url"]!="#" ? esc_attr($settings["form_action_url"]) : "#") . '" method="post" class="cost-calculator-container cost-calculator-form">';
		$this->print_child(0); 
		echo '<input type="hidden" name="cost-calculator-form-id" value="' . esc_attr($settings["cost_calculator_id"]) . '"></form>';
	}

	protected function content_template()
	{
		?>
		<# 
		view.addRenderAttribute('cost_calculator_id', 'id', settings['cost_calculator_id']);
		view.addRenderAttribute('cost_calculator_id_hidden', 'value', settings['cost_calculator_id']);
		view.addRenderAttribute('form_action_url', 'action', settings['form_action_url']);
		view.addRenderAttribute('method', 'method', 'post');
		#>
		<form {{{view.getRenderAttributeString("cost_calculator_id")}}} {{{view.getRenderAttributeString("form_action_url")}}} {{{view.getRenderAttributeString("method")}}} class="cost-calculator-container cost-calculator-form">
		<input type="hidden" name="cost-calculator-form-id" {{{view.getRenderAttributeString("cost_calculator_id_hidden")}}}>
		</form>
		<?php
	}
}