<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class QLCostCalculator_DropdownBox extends Widget_Base 
{

	public function get_name()
	{
		return 'cost_calculator_dropdown_box';
	}

	public function get_title()
	{
		return esc_html__("Cost Calculator Dropdown Box", 'cost-calculator');
	}

	public function get_icon()
	{
		return 'eicon-select';
	}

	public function get_categories()
	{
		return ['ql_cost_calculator_widgets'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'cost-calculator'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'dropdown_box_id',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Id", 'cost-calculator'),
				'default' => 'dropdown-box',
				'description' => esc_html__("Please provide unique id for each 'Cost Calculator Dropdown Box' on your page.", 'cost-calculator')
			]
		);
		$this->add_control(
			'name',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Input name", 'cost-calculator'),
				'default' => 'dropdown-box'
			]
		);
		$this->add_control(
			'label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Label", 'cost-calculator')
			]
		);
		$this->add_control(
			'hide_label',
			[
				'label' => esc_html__("Hide label", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '',
				'description' => esc_html__("Set to 'Yes' if you won't like to display label in the frontend but you still like to receive field value via email", 'cost-calculator')
			]
		);
		$this->add_control(
			'options',
			[
				'label' => esc_html__("Options", 'cost-calculator'),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'option_name',
						'label' => esc_html__("Option name", 'cost-calculator'),
						'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__("Option", 'cost-calculator')
					],
					[
						'name' => 'option_value',
						'label' => esc_html__("Option value", 'cost-calculator'),
						'type' => \Elementor\Controls_Manager::TEXT
					]
				],
				'default' => [
					[
						'option_name' => esc_html__("Option #1", 'cost-calculator')
					],
					[
						'option_name' => esc_html__("Option #2", 'cost-calculator')
					]
				],
				'title_field' => '{{{ option_name }}}',
			]
		);
		$this->add_control(
			'default_value',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Default value", 'cost-calculator')
			]
		);
		$this->add_control(
			'show_choose_label',
			[
				'label' => esc_html__("Show 'choose' label", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '1'
			]
		);
		$this->add_control(
			'choose_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Choose label", 'cost-calculator'),
				'default' => esc_html__("Choose...", 'cost-calculator'),
				'condition' => [
					'show_choose_label' => '1'
				]
			]
		);
		$this->add_control(
			'required',
			[
				'label' => esc_html__("Required", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => "1",
				'default' => '',
				'condition' => [
					'show_choose_label' => '1'
				]
			]
		);
		$this->add_control(
			'required_message',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Required field message", 'cost-calculator'),
				'default' => esc_html__("This field is required", 'cost-calculator'),
				'condition' => [
					'required' => '1'
				]
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["dropdown_box_id"]))
		{
			$settings["id"] = $settings["dropdown_box_id"];
		}
		echo cost_calculator_dropdown_box_shortcode($settings);
	}

	protected function content_template(){}
}
?>
