<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class QLCostCalculator_CostCalculator extends Widget_Base 
{

	public function get_name()
	{
		return 'cost_calculator';
	}

	public function get_title()
	{
		return esc_html__("Cost Calculator", 'cost-calculator');
	}

	public function get_icon()
	{
		return 'eicon-form-horizontal';
	}

	public function get_categories()
	{
		return ['ql_cost_calculator_main'];
	}

	protected function is_dynamic_content():bool 
	{
		return true;
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'cost-calculator'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$cost_calculator_shortcodes_list = get_option("cost_calculator_shortcodes_list");
		$cost_calculator_shortcodes_array = array("-1" => esc_html__("choose...", "cost-calculator"));
		if(!empty($cost_calculator_shortcodes_list))
		{
			foreach($cost_calculator_shortcodes_list as $key=>$val)
			{
				$cost_calculator_shortcodes_array[$key] = $key;
			}
		}
		$this->add_control(
			'cost_calculator_id',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Id", 'cost-calculator'),
				'default' => '-1',
				'options' => $cost_calculator_shortcodes_array,
				'description' => sprintf(__("You can manage the shortcodes under <a href='%s' title='Cost Calculator'>Cost Calculator</a> in the admin area", 'cost-calculator'), esc_url(admin_url("admin.php?page=cost_calculator")))
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if(!empty($settings["cost_calculator_id"]))
		{
			$settings["id"] = $settings["cost_calculator_id"];
		}
		if((int)\Elementor\Plugin::$instance->editor->is_edit_mode())
		{
			$settings["is_elementor_edit_mode"] = 1;
		}
		echo cost_calculator($settings);
	}

	protected function content_template(){}
}
?>