<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

class QLCostCalculator_ContactBox extends Widget_Base 
{

	public function get_name()
	{
		return 'cost_calculator_contact_box';
	}

	public function get_title()
	{
		return esc_html__("Cost Calculator Contact Box", 'cost-calculator');
	}

	public function get_icon()
	{
		return 'eicon-form-horizontal';
	}

	public function get_categories()
	{
		return ['ql_cost_calculator_widgets'];
	}

	protected function is_dynamic_content():bool 
	{
		return false;
	}

	protected function register_controls()
	{
		$cost_calculator_options = new QLCostCalculator_Options();
		$cost_calculator_global_form_options = $cost_calculator_options->getGlobalFormOptions();
		$cost_calculator_payments_options = $cost_calculator_options->getPaymentsOptions();
		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__("Content", 'cost-calculator'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Form label", 'cost-calculator')
			]
		);
		$this->add_control(
			'submit_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Submit label", 'cost-calculator'),
				'default' => esc_html__("Submit now", 'cost-calculator')
			]
		);
		$this->add_control(
			'name_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Name label", 'cost-calculator'),
				'default' => esc_html__("YOUR NAME", 'cost-calculator')
			]
		);
		$this->add_control(
			'name_placeholder',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Name placeholder", 'cost-calculator'),
				'default' => esc_html__("YOUR NAME", 'cost-calculator')
			]
		);
		$this->add_control(
			'name_required',
			[
				'label' => esc_html__("Name field required", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '1'
			]
		);
		$this->add_control(
			'email_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Email label", 'cost-calculator'),
				'default' => esc_html__("YOUR EMAIL", 'cost-calculator')
			]
		);
		$this->add_control(
			'email_placeholder',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Email placeholder", 'cost-calculator'),
				'default' => esc_html__("YOUR EMAIL", 'cost-calculator')
			]
		);
		$this->add_control(
			'email_required',
			[
				'label' => esc_html__("Email field required", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => '1'
			]
		);
		$this->add_control(
			'phone_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Phone label", 'cost-calculator'),
				'default' => esc_html__("YOUR PHONE", 'cost-calculator')
			]
		);
		$this->add_control(
			'phone_placeholder',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Phone placeholder", 'cost-calculator'),
				'default' => esc_html__("YOUR PHONE", 'cost-calculator')
			]
		);
		$this->add_control(
			'phone_required',
			[
				'label' => esc_html__("Phone field required", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => ''
			]
		);
		$this->add_control(
			'message_label',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Message label", 'cost-calculator'),
				'default' => esc_html__("QUESTIONS OR COMMENTS", 'cost-calculator')
			]
		);
		$this->add_control(
			'message_placeholder',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Message placeholder", 'cost-calculator'),
				'default' => esc_html__("QUESTIONS OR COMMENTS", 'cost-calculator')
			]
		);
		$this->add_control(
			'message_required',
			[
				'label' => esc_html__("Message field required", 'cost-calculator'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'cost-calculator'),
				'label_off' => esc_html__('No', 'cost-calculator'),
				'return_value' => '1',
				'default' => ''
			]
		);
		$this->add_control(
			'description',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Description", 'cost-calculator')
			]
		);
		$this->add_control(
			'labels_style',
			[
				'type' => Controls_Manager::SELECT,
				'label' => esc_html__("Labels style", 'cost-calculator'),
				'options' => [
					'default' => esc_html__("Display labels only", 'cost-calculator'),
					'labelplaceholder' => esc_html__("Display labels and placeholders", 'cost-calculator'),
					'placeholder' => esc_html__("Display placeholders only", 'cost-calculator')
				],
				'default' => 'default'
			]
		);
		$this->add_control(
			'terms_checkbox',
			[
				'type' => \Elementor\Controls_Manager::SELECT,
				'label' => esc_html__("Terms and conditions checkbox", 'cost-calculator'),
				'options' => [
					'1' => esc_html__("Yes", 'cost-calculator'),
					'0' => esc_html__("No", 'cost-calculator')
				],
				'default' => '0'
			]
		);
		$this->add_control(
			'terms_message',
			[
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label' => esc_html__("Terms and conditions message", 'cost-calculator'),
				'rows' => 5,
				'default' => esc_html__("Please accept terms and conditions", 'cost-calculator'),
				'condition' => [
					'terms_checkbox' => "1",
				]
			]
		);
		if((int)$cost_calculator_payments_options["stripe_payments_enabled"])
		{
			$this->add_control(
				'payments_enabled',
				[
					'label' => esc_html__("Payments enabled", 'cost-calculator'),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__('Yes', 'cost-calculator'),
					'label_off' => esc_html__('No', 'cost-calculator'),
					'return_value' => '1',
					'default' => ((int)$cost_calculator_payments_options["stripe_payments_enabled"] ? '1' : '')
				]
			);
		}
		$this->add_control(
			'recaptcha',
			[
				'type' => \Elementor\Controls_Manager::TEXT,
				'label' => esc_html__("reCaptcha", 'cost-calculator'),
				'default' => ((int)$cost_calculator_global_form_options["google_recaptcha"]>0 ? __("Yes", 'cost-calculator') : __("No", 'cost-calculator')),
				'description' => sprintf(__("You can change this setting under <a href='%s' title='Global Config'>Global Config</a>", 'cost-calculator'), esc_url(admin_url("admin.php?page=cost_calculator_admin_page_global_config"))),
				'classes' => "cost-calculator-elementor-readonly"
			]
		);
		$this->add_control(
			'append',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Append data from another form (enter form id)", 'cost-calculator'),
				'description' => esc_html__("Enter form id from which you would like to append data to this form submission.", 'cost-calculator')
			]
		);
		$this->add_control(
			'type',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Type", 'cost-calculator')
			]
		);
		$this->add_control(
			'el_class',
			[
				'type' => Controls_Manager::TEXT,
				'label' => esc_html__("Extra class name", 'cost-calculator'),
				'description' => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'cost-calculator')
			]
		);
		$this->end_controls_section();

	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		echo cost_calculator_contact_box_shortcode($settings);
	}

	protected function content_template(){}
}
?>
