<div class="wrap cost-calculator-settings-section">
	<h2><?php _e("Cost Calculator", "cost-calculator"); ?></h2>
</div>
<div class="updated settings-error" id="cost-calculator-shortcode-info"></div>
<?php
//get google fonts
$fontsArray = cc_get_google_fonts();
?>
<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post" id="cost-calculator-form">
	<div class="cost-calculator-form-container">
		<div class="cost-calculator-form-container-row cost-calculator-clearfix">
			<div class="cost-calculator-column-left">
				<label for="edit-cost-calculator-shortcode-id"><?php _e("Choose shortcode id for edit: ", "cost-calculator"); ?></label>
			</div>
			<div class="cost-calculator-column-right">
				<select id="edit-cost-calculator-shortcode-id" class="cost-calculator-admin-dropdown">
					<option value="-1" selected="selected"><?php _e("Choose...", "cost-calculator"); ?></option>
						<?php
							$cost_calculator_shortcodes_list = get_option("cost_calculator_shortcodes_list");
							if(!empty($cost_calculator_shortcodes_list))
							{
								foreach($cost_calculator_shortcodes_list as $key=>$val)
								{
									echo "<option value='{$key}'>{$key}</option>";
								}
							}
						?>
				</select>
				<span class="spinner"></span>
				<img id="shortcode-delete" src="<?php echo esc_url(plugins_url('images/delete.png', __FILE__));?>" alt="del" title="<?php _e("Delete this shortcode", "cost-calculator"); ?>">
			</div>
		</div>
		<div class="cost-calculator-form-container-row cost-calculator-clearfix">
			<div class="cost-calculator-column-left">
				<label for="cost-calculator-shortcode-id" id="cost-calculator-shortcode-id-label"><?php _e("Create new shortcode id *", "cost-calculator"); ?></label>
			</div>
			<div class="cost-calculator-column-right">
				<input type="text" class="regular-text" id="cost-calculator-shortcode-id" value="" pattern="[a-zA-z0-9_-]+" title="<?php _e("Please use only listed characters: letters, numbers, hyphen(-) and underscore(_)", "cost-calculator"); ?>"/>
				<span class="description"><?php _e("Unique identifier for cost calculator shortcode.", "cost-calculator"); ?></span>
			</div>
		</div>
		<div class="cost-calculator-form-container-row cost-calculator-advanced-settings-button-container cost-calculator-clearfix">
			<a class="cost-calculator-advanced-settings" href="#"><?php _e("Show advanced settings...", "cost-calculator"); ?></a>
		</div>
		<div class="cost-calculator-hidden">
			<div class="cost-calculator-advanced-settings-container cost-calculator-clearfix">
				<h3><?php _e("Colors config", 'cost-calculator'); ?></h3>
				<div class="cost-calculator-advanced-settings-column cost-calculator-advanced-settings-left">
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="calculator_skin"><?php _e("Predefined skin", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="calculator_skin" name="calculator_skin" class="cost-calculator-skin-dropdown">
								<option value="default"><?php _e("Skin 1 (Clean)", 'cost-calculator'); ?></option>
								<option value="carservice"><?php _e("Skin 2 (Car Service)", 'cost-calculator'); ?></option>
								<option value="renovate"><?php _e("Skin 3 (Renovation)", 'cost-calculator'); ?></option>
								<option value="gymbase"><?php _e("Skin 4 (GymBase)", 'cost-calculator'); ?></option>
								<option value="finpeak"><?php _e("Skin 5 (Finpeak)", 'cost-calculator'); ?></option>
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Main color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: #56B665;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="main_color" name="main_color" data-default-color="56B665">
							</div>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Box background color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: transparent;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="box_color" name="box_color" data-default-color="transparent">
							</div>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Text color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: #303030;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="text_color" name="text_color" data-default-color="303030">
							</div>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Borders color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: #EBEBEB;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="border_color" name="border_color" data-default-color="EBEBEB">
							</div>
						</div>
					</div>
				</div>
				<div class="cost-calculator-advanced-settings-column cost-calculator-advanced-settings-right">
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Labels color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: #303030;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="label_color" name="label_color" data-default-color="303030">
							</div>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Dropdown and checkbox label color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: #303030;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="dropdowncheckbox_label_color" name="dropdowncheckbox_label_color" data-default-color="303030">
							</div>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Form labels color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: #999999;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="form_label_color" name="form_label_color" data-default-color="999999">
							</div>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Inactive color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: #EEEEEE;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="inactive_color" name="inactive_color" data-default-color="EEEEEE">
							</div>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="main_color"><?php _e("Slider tooltip background color", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<div class="cost-calculator-colorpicker-container">
								<span class="cost-calculator-color-preview" style="background-color: #FFFFFF;"></span>
								<input type="text" class="regular-text cost-calculator-color input-short" value="" id="tooltip_background_color" name="tooltip_background_color" data-default-color="FFFFFF">
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="cost-calculator-advanced-settings-container cost-calculator-clearfix">
				<h3><?php _e("Fonts config", 'cost-calculator'); ?></h3>
				<div class="cost-calculator-advanced-settings-column cost-calculator-advanced-settings-left">
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="primary_font_custom"><?php _e("Primary font name", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<input type="text" class="regular-text input-short" value="" id="primary_font_custom" name="primary_font_custom">
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-fonts-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="cc_primary_font"><?php _e("Primary font google", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<span class="spinner"></span>
							<select id="cc_primary_font" name="primary_font" class="cost-calculator-fonts-dropdown">
								<option selected="selected" value=""><?php _e("Default (Raleway)", 'cost-calculator'); ?></option>
								<?php
								$fontsCount = count($fontsArray->items);
								for($i=0; $i<$fontsCount; $i++)
								{
									?>
									<option value="<?php echo esc_attr($fontsArray->items[$i]->family); ?>"><?php echo $fontsArray->items[$i]->family; ?></option>
									<?php
								}
								?>
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix cost-calculator-hidden">
						<div class="cost-calculator-column-left">
							<label for="primary_font_variant"><?php _e("Google font variant", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="primary_font_variant" name="primary_font_variant[]" class="cost-calculator-multiselect font-variant" multiple="multiple">
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix cost-calculator-hidden">
						<div class="cost-calculator-column-left">
							<label for="primary_font_subset"><?php _e("Google font subset", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="primary_font_subset" name="primary_font_subset[]" class="cost-calculator-multiselect font-subset" multiple="multiple">
							</select>
						</div>
					</div>
				</div>
				<div class="cost-calculator-advanced-settings-column cost-calculator-advanced-settings-right">
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="secondary_font_custom"><?php _e("Secondary font name", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<input type="text" class="regular-text input-short" value="" id="secondary_font_custom" name="secondary_font_custom">
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-fonts-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="cc_secondary_font"><?php _e("Secondary font google", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<span class="spinner"></span>
							<select id="cc_secondary_font" name="secondary_font" class="cost-calculator-fonts-dropdown">
								<option selected="selected" value=""><?php _e("Default (Lato)", 'cost-calculator'); ?></option>
								<?php
								$fontsCount = count($fontsArray->items);
								for($i=0; $i<$fontsCount; $i++)
								{
									?>
									<option value="<?php echo esc_attr($fontsArray->items[$i]->family); ?>"><?php echo $fontsArray->items[$i]->family; ?></option>
									<?php
								}
								?>
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix cost-calculator-hidden">
						<div class="cost-calculator-column-left">
							<label for="secondary_font_variant"><?php _e("Google font variant", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="secondary_font_variant" name="secondary_font_variant[]" class="cost-calculator-multiselect font-variant" multiple="multiple">
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix cost-calculator-hidden">
						<div class="cost-calculator-column-left">
							<label for="secondary_font_subset"><?php esc_html_e("Google font subset", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="secondary_font_subset" name="secondary_font_subset[]" class="cost-calculator-multiselect font-subset" multiple="multiple">
							</select>
						</div>
					</div>
				</div>
			</div>
			<div class="cost-calculator-advanced-settings-container cost-calculator-clearfix">
				<h3><?php esc_html_e("Payments", 'cost-calculator'); ?></h3>
				<?php if((int)$cost_calculator_payments_options["stripe_payments_enabled"]==1)
				{
				?>
				<div class="cost-calculator-advanced-settings-column cost-calculator-advanced-settings-left">
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="payments_enabled"><?php esc_html_e("Payments enabled", 'cost-calculator'); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="payments_enabled" name="payments_enabled" class="cost-calculator-dropdown">
								<option selected="selected" value="1"><?php esc_html_e("Yes", 'cost-calculator'); ?></option>
								<option value="0"><?php esc_html_e("No", 'cost-calculator'); ?></option>
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix cost-calculator-payments-enabled-depends">
						<div class="cost-calculator-column-left">
							<label for="total_field_name"><?php esc_html_e("Total amount field name", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<input type="text" class="regular-text input-short" value="total_cost" id="total_field_name" name="total_field_name">
							<label class="small-label"><?php esc_html_e("'Summary Box' name with amount value to be paid", 'cost-calculator'); ?></label>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix cost-calculator-payments-enabled-depends">
						<div class="cost-calculator-column-left">
							<label for="payment_recurring"><?php esc_html_e("Recurring", 'cost-calculator'); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="payment_recurring" name="payment_recurring" class="cost-calculator-dropdown">
								<option selected="selected" value="one_time"><?php esc_html_e("One time payment", 'cost-calculator'); ?></option>
								<option value="day"><?php esc_html_e("Daily payment", 'cost-calculator'); ?></option>
								<option value="week"><?php esc_html_e("Weekly payment", 'cost-calculator'); ?></option>
								<option value="month"><?php esc_html_e("Monthly payment", 'cost-calculator'); ?></option>
								<option value="year"><?php esc_html_e("Yearly payment", 'cost-calculator'); ?></option>
								<option value="dynamic"><?php esc_html_e("Dynamic (from Dropdown Box)", 'cost-calculator'); ?></option>
							</select>
						</div>
					</div>
				</div>
				<div class="cost-calculator-advanced-settings-column cost-calculator-advanced-settings-right cost-calculator-payments-enabled-depends">
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="payment_method"><?php esc_html_e("Payment method", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="payment_method" name="payment_method" class="cost-calculator-dropdown">
								<option selected="selected" value="on_submit"><?php esc_html_e("On form submit", 'cost-calculator'); ?></option>
								<option value="email_link"><?php esc_html_e("Via e-mail payment link", 'cost-calculator'); ?></option>
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="payment_currency"><?php esc_html_e("Payment currency", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<input type="text" class="regular-text input-short" value="usd" id="payment_currency" name="payment_currency">
							<label class="small-label"><?php echo sprintf(__("Please provide currency <a href='%s' title='%s' target='_blank'>three-letter ISO code</a>", 'cost-calculator'), esc_url("https://stripe.com/docs/currencies#presentment-currencies"), esc_attr("Supported currencies", 'cost-calculator')); ?></label>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix cost-calculator-payment-recurring-depends cost-calculator-hidden">
						<div class="cost-calculator-column-left">
							<label for="payment_recurring_interval"><?php esc_html_e("Recurring interval", 'cost-calculator'); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="payment_recurring_interval" name="payment_recurring_interval" class="cost-calculator-dropdown">
								<option selected="selected" value="1"><?php esc_html_e("every 1 period", 'cost-calculator'); ?></option>
								<option value="2"><?php esc_html_e("every 2 periods", 'cost-calculator'); ?></option>
								<option value="3"><?php esc_html_e("every 3 periods", 'cost-calculator'); ?></option>
								<option value="4"><?php esc_html_e("every 4 periods", 'cost-calculator'); ?></option>
								<option value="5"><?php esc_html_e("every 5 periods", 'cost-calculator'); ?></option>
								<option value="6"><?php esc_html_e("every 6 periods", 'cost-calculator'); ?></option>
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix cost-calculator-payment-recurring-depends-dynamic cost-calculator-hidden">
						<div class="cost-calculator-column-left">
							<label for="payment_recurring_field_name"><?php esc_html_e("Dropdown Box name", 'cost-calculator'); ?> <a href="#" class="cost-calculator-help"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 496.158 496.158" xml:space="preserve"><path style="fill:#6E6E91;" d="M496.158,248.085c0-137.022-111.069-248.082-248.075-248.082C111.07,0.003,0,111.063,0,248.085	c0,137.001,111.07,248.07,248.083,248.07C385.089,496.155,496.158,385.086,496.158,248.085z"/><path style="fill:#FFFFFF;" d="M138.216,173.592c0-13.915,4.467-28.015,13.403-42.297c8.933-14.282,21.973-26.11,39.111-35.486 c17.139-9.373,37.134-14.062,59.985-14.062c21.238,0,39.99,3.921,56.25,11.755c16.26,7.838,28.818,18.495,37.683,31.97 c8.861,13.479,13.293,28.125,13.293,43.945c0,12.452-2.527,23.367-7.581,32.739c-5.054,9.376-11.062,17.469-18.018,24.279	c-6.959,6.812-19.446,18.275-37.463,34.388c-4.981,4.542-8.975,8.535-11.975,11.976c-3.004,3.443-5.239,6.592-6.702,9.447 c-1.466,2.857-2.603,5.713-3.406,8.57c-0.807,2.855-2.015,7.875-3.625,15.051c-2.784,15.236-11.501,22.852-26.147,22.852 c-7.618,0-14.028-2.489-19.226-7.471c-5.201-4.979-7.8-12.377-7.8-22.192c0-12.305,1.902-22.962,5.713-31.97	c3.808-9.01,8.861-16.92,15.161-23.73c6.296-6.812,14.794-14.904,25.488-24.28c9.373-8.202,16.15-14.392,20.325-18.567 c4.175-4.175,7.69-8.823,10.547-13.953c2.856-5.126,4.285-10.691,4.285-16.699c0-11.718-4.36-21.605-13.074-29.663 c-8.717-8.054-19.961-12.085-33.728-12.085c-16.116,0-27.981,4.065-35.596,12.195c-7.618,8.13-14.062,20.105-19.336,35.925 c-4.981,16.555-14.43,24.829-28.345,24.829c-8.206,0-15.127-2.891-20.764-8.679C141.035,186.593,138.216,180.331,138.216,173.592z M245.442,414.412c-8.937,0-16.737-2.895-23.401-8.68c-6.667-5.784-9.998-13.877-9.998-24.279c0-9.229,3.22-16.991,9.668-23.291 c6.444-6.297,14.354-9.448,23.73-9.448c9.229,0,16.991,3.151,23.291,9.448c6.296,6.3,9.448,14.062,9.448,23.291 c0,10.255-3.296,18.312-9.888,24.17C261.7,411.481,254.084,414.412,245.442,414.412z"/></svg></a></label>
						</div>
						<div class="cost-calculator-column-right">
							<input type="text" class="regular-text input-short" value="dropdown-box" id="payment_recurring_field_name" name="payment_recurring_field_name">
							<label class="small-label"><?php esc_html_e("'Dropdown Box' name with defined recurring options", 'cost-calculator'); ?></label>
						</div>
					</div>
				</div>
				<?php
				}
				else
				{
					?><label><?php printf(__("Payments disabled under <a href='%s' title='Payments Config'>Payments Config</a>", 'cost-calculator'), esc_url(admin_url("admin.php?page=cost_calculator_admin_page_payments_config")));?></label><?php
				}
				?>
			</div>
			<div class="cost-calculator-advanced-settings-container cost-calculator-clearfix">
				<h3><?php _e("Other", 'cost-calculator'); ?></h3>
				<div class="cost-calculator-advanced-settings-column cost-calculator-advanced-settings-left">
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="form_display"><?php _e("Form display", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<select id="form_display" name="form_display" class="cost-calculator-dropdown">
								<option selected="selected" value="visible"><?php esc_html_e("Visible", 'cost-calculator'); ?></option>
								<option value="hidden"><?php esc_html_e("Hidden", 'cost-calculator'); ?></option>
							</select>
						</div>
					</div>
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="thank_you_page_url"><?php _e("Thank you page url", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<input type="text" class="regular-text input-short" value="" id="thank_you_page_url" name="thank_you_page_url">
						</div>
					</div>
				</div>
				<div class="cost-calculator-advanced-settings-column cost-calculator-advanced-settings-right">
					<div class="cost-calculator-form-container-row cost-calculator-clearfix">
						<div class="cost-calculator-column-left">
							<label for="form_action_url"><?php _e("Form action url", "cost-calculator"); ?></label>
						</div>
						<div class="cost-calculator-column-right">
							<input type="text" class="regular-text input-short" value="#" id="form_action_url" name="form_action_url">
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
	/*
	<!--<a class="button thickbox" href="#TB_inline?width=600&height=550&inlineId=row-modal" title="<?php esc_attr_e("Row Settings", 'cost-calculator'); ?>"><?php _e("Row", 'cost-calculator'); ?></a>-->
	<a class="button add-row" href="#" title="<?php esc_attr_e("Add new row", 'cost-calculator'); ?>"><?php _e("Add new row", 'cost-calculator'); ?></a>
	<!--<a class="button thickbox" href="#TB_inline?width=600&height=550&inlineId=column-modal" title="<?php esc_attr_e("Column Settings", 'cost-calculator'); ?>"><?php _e("Column", 'cost-calculator'); ?></a>-->
	<a class="button thickbox" href="#TB_inline?width=600&height=550&inlineId=dropdown-box-modal" title="<?php esc_attr_e("Dropdown Box Settings", 'cost-calculator'); ?>"><?php _e("Dropdown Box", 'cost-calculator'); ?></a>
	<a class="button thickbox" href="#TB_inline?width=600&height=550&inlineId=slider-box-modal" title="<?php esc_attr_e("Slider Box Settings", 'cost-calculator'); ?>"><?php _e("Slider Box", 'cost-calculator'); ?></a>
	<a class="button thickbox" href="#TB_inline?width=600&height=550&inlineId=input-box-modal" title="<?php esc_attr_e("Input Box Settings", 'cost-calculator'); ?>"><?php _e("Input Box", 'cost-calculator'); ?></a>
	<a class="button thickbox" href="#TB_inline?width=600&height=550&inlineId=switch-box-modal" title="<?php esc_attr_e("Switch Box Settings", 'cost-calculator'); ?>"><?php _e("Switch Box", 'cost-calculator'); ?></a>
	<a class="button thickbox" href="#TB_inline?width=600&height=550&inlineId=summary-box-modal" title="<?php esc_attr_e("Summary Box Settings", 'cost-calculator'); ?>"><?php _e("Summary Box", 'cost-calculator'); ?></a>
	<a class="button thickbox" href="#TB_inline?width=600&height=550&inlineId=contact-box-modal" title="<?php esc_attr_e("Contact Box Settings", 'cost-calculator'); ?>"><?php _e("Contact Box", 'cost-calculator'); ?></a>
	*/?>
	<p class="cost-calculator-submit">
		<span class="cc-plugin-button-tick"></span>
		<input type="submit" name="submit" class="cost-calculator-save-changes cost-calculator-button" value="<?php esc_attr_e("Save Shortcode", 'cost-calculator'); ?>">
		<span class="spinner" style="float: none; margin: 0 10px;"></span>
	</p>
	<div class="cost-calculator-form-container">
		<a class="cost-calculator-add-row cost-calculator-button" href="#" title="<?php esc_attr_e("Add Row", 'cost-calculator'); ?>"><?php _e("Add Row", 'cost-calculator'); ?></a>
		<div id="cost-calculator-shortcode-builder">
			<div class="cost-calculator-row" data-row-layout="columns_1_1-1">
				<div class="cost-calculator-row-bar">
					<div class="cost-calculator-sortable-handle cost-calculator-row-sortable-handle"></div>
					<select name="row-layout" class="cost-calculator-row-layout">
						<option value="columns_1_1-1" selected="selected"><?php _e("1 column", 'cost-calculator');?></option>
						<option value="columns_2_1-2_1-2"><?php _e("2 columns", 'cost-calculator');?></option>
						<option value="columns_3_1-3_1-3_1-3"><?php _e("3 columns", 'cost-calculator');?></option>
						<option value="columns_4_1-4_1-4_1-4_1-4"><?php _e("4 columns", 'cost-calculator');?></option>
						<option value="columns_2_2-3_1-3"><?php _e("2/3+1/3", 'cost-calculator');?></option>
						<option value="columns_2_3-4_1-4"><?php _e("3/4+1/4", 'cost-calculator');?></option>
						<option value="columns_3_1-4_1-2_1-4"><?php _e("1/4+1/2+1/4", 'cost-calculator');?></option>
					<select>
					<a href="#" class="cost-calculator-remove-row" title="<?php esc_attr_e("Remove Row", 'cost-calculator'); ?>"></a>
					<a href="#" class="cost-calculator-edit-row" title="<?php esc_attr_e("Edit Row Settings", 'cost-calculator'); ?>"></a>
				</div>
				<div class="cost-calculator-columns-container cost-calculator-clearfix">
					<div class="cost-calculator-column column-1-1">
						<div class="cost-calculator-column-bar">
							<div class="cost-calculator-sortable-handle cost-calculator-column-sortable-handle"></div>
							<select name="add-element" class="cost-calculator-add-element">
								<option value="-1" selected="selected"><?php _e("Add Element", 'cost-calculator');?></option>
								<option value="dropdown-box"><?php _e("Dropdown Box", 'cost-calculator');?></option>
								<option value="slider-box"><?php _e("Slider Box", 'cost-calculator');?></option>
								<option value="input-box"><?php _e("Input Box", 'cost-calculator');?></option>
								<option value="switch-box"><?php _e("Switch Box", 'cost-calculator');?></option>
								<option value="summary-box"><?php _e("Summary Box", 'cost-calculator');?></option>
								<option value="contact-box"><?php _e("Contact Box", 'cost-calculator');?></option>
							<select>
							<a href="#" class="cost-calculator-edit-column" title="<?php esc_attr_e("Edit Column Settings", 'cost-calculator'); ?>"></a>
						</div>
						<textarea class="cost-calculator-content-area"></textarea>
					</div>
				</div>
			</div>
		</div>
		<a class="cost-calculator-add-row cost-calculator-button" href="#" title="<?php esc_attr_e("Add Row", 'cost-calculator'); ?>"><?php _e("Add Row", 'cost-calculator'); ?></a>
	</div>
	<p class="cost-calculator-submit">
		<span class="cc-plugin-button-tick"></span>
		<input type="submit" name="submit" class="cost-calculator-save-changes cost-calculator-button" value="<?php esc_attr_e("Save Shortcode", 'cost-calculator'); ?>">
		<span class="spinner" style="float: none; margin: 0 10px;"></span>
	</p>
</form>
<?php
require_once("row.php");
require_once("column.php");
require_once("dropdown_box.php");
require_once("slider_box.php");
require_once("input_box.php");
require_once("switch_box.php");
require_once("summary_box.php");
require_once("contact_box.php");
require_once("help.php");
?>