<div class="wrap cost-calculator-settings-section">
	<h2><?php _e("Payments Config", "cost-calculator"); ?></h2>
</div>
<?php
if(!empty($message))
{
?>
<div class="<?php echo ($message!="" ? "updated" : ""); ?> settings-error"> 
	<p>
		<?php echo $message; ?>
	</p>
</div>
<?php
}
if(!empty($error))
{
	?>
	<div class="<?php echo ($error!="" ? "error" : ""); ?> settings-error"> 
		<p>
			<?php echo $error; ?>
		</p>
	</div>
	<?php
}
//get google fonts
$fontsArray = cc_get_google_fonts();
?>
<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post" class="cost-calculator-config-form">
	<div class="cost-calculator-form-table-container">
		<table class="form-table">
			<tbody>
				<tr valign="top">
					<th scope="row">
						<label for="stripe_payments_enabled">
							<?php esc_html_e("Stripe payments enabled", 'cost-calculator'); ?>
						</label>
					</th>
					<td>
						<select id="stripe_payments_enabled" name="stripe_payments_enabled">
							<option value="0"<?php echo (empty($cost_calculator_payments_options["stripe_payments_enabled"]) || !(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? " selected='selected'" : ""); ?>><?php esc_html_e("no", 'cost-calculator'); ?></option>
							<option value="1"<?php echo ((int)$cost_calculator_payments_options["stripe_payments_enabled"]==1 ? " selected='selected'" : ""); ?>><?php esc_html_e("yes", 'cost-calculator'); ?></option>
						</select>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="stripe_api_secret_key">
							<?php esc_html_e("Stripe API secret key", 'cost-calculator'); ?>
						</label>
					</th>
					<td>
						<input type="text" class="regular-text input-full-width" value="<?php echo esc_attr($cost_calculator_payments_options["stripe_api_secret_key"]); ?>" id="stripe_api_secret_key" name="stripe_api_secret_key">
						<label class="small_label"><?php echo sprintf(__("Get Stripe API key <a href='%s' title='%s' target='_blank'>here</a>", 'cost-calculator'), esc_url("https://dashboard.stripe.com/apikeys"), esc_attr("Stripe API key", 'cost-calculator')); ?></label>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="stripe_api_secret_key">
							<?php esc_html_e("Stripe payment methods", 'cost-calculator'); ?>
						</label>
					</th>
					<td>
						<a href="https://dashboard.stripe.com/settings/payment_methods" title="<?php esc_attr_e("Manage payment methods", 'cost-calculator'); ?>" target="_blank"><?php esc_html_e("Manage payment methods", 'cost-calculator'); ?></a>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="payment_method">
							<?php esc_html_e("Payment method", "cost-calculator"); ?>
						</label>
					</th>
					<td>
						<select id="payment_method" name="payment_method">
							<option value="on_submit"<?php echo (empty($cost_calculator_payments_options["payment_method"]) || $cost_calculator_payments_options["payment_method"]=="on_submit" ? " selected='selected'" : ""); ?>><?php esc_html_e("On form submit", 'cost-calculator'); ?></option>
							<option value="email_link"<?php echo ($cost_calculator_payments_options["payment_method"]=="email_link" ? " selected='selected'" : ""); ?>><?php esc_html_e("Via e-mail payment link", 'cost-calculator'); ?></option>
						</select>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="total_field_name">
							<?php esc_html_e("Total amount field name", 'cost-calculator'); ?>
						</label>
					</th>
					<td>
						<input type="text" class="regular-text input-full-width" value="<?php echo esc_attr($cost_calculator_payments_options["total_field_name"]); ?>" id="total_field_name" name="total_field_name">
						<label class="small_label"><?php esc_html_e("'Summary Box' name with amount value to be paid", 'cost-calculator'); ?></label>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="payment_currency">
							<?php esc_html_e("Payment currency", 'cost-calculator'); ?>
						</label>
					</th>
					<td>
						<input type="text" class="regular-text input-full-width" value="<?php echo esc_attr($cost_calculator_payments_options["payment_currency"]); ?>" id="payment_currency" name="payment_currency">
						<label class="small_label"><?php echo sprintf(__("Provide currency <a href='%s' title='%s' target='_blank'>three-letter ISO code</a>", 'cost-calculator'), esc_url("https://stripe.com/docs/currencies#presentment-currencies"), esc_attr("Supported currencies", 'cost-calculator')); ?></label>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="payment_recurring">
							<?php esc_html_e("Recurring", "cost-calculator"); ?>
						</label>
					</th>
					<td>
						<select id="payment_recurring" name="payment_recurring">
							<option value="one_time"<?php echo (empty($cost_calculator_payments_options["payment_recurring"]) || $cost_calculator_payments_options["payment_recurring"]=="one_time" ? " selected='selected'" : ""); ?>><?php esc_html_e("One time payment", 'cost-calculator'); ?></option>
							<option value="day"<?php echo ($cost_calculator_payments_options["payment_recurring"]=="day" ? " selected='selected'" : ""); ?>><?php esc_html_e("Daily payment", 'cost-calculator'); ?></option>
							<option value="week"<?php echo ($cost_calculator_payments_options["payment_recurring"]=="week" ? " selected='selected'" : ""); ?>><?php esc_html_e("Weekly payment", 'cost-calculator'); ?></option>
							<option value="month"<?php echo ($cost_calculator_payments_options["payment_recurring"]=="month" ? " selected='selected'" : ""); ?>><?php esc_html_e("Monthly payment", 'cost-calculator'); ?></option>
							<option value="year"<?php echo ($cost_calculator_payments_options["payment_recurring"]=="year" ? " selected='selected'" : ""); ?>><?php esc_html_e("Yearly payment", 'cost-calculator'); ?></option>
							<option value="dynamic"<?php echo ($cost_calculator_payments_options["payment_recurring"]=="dynamic" ? " selected='selected'" : ""); ?>><?php esc_html_e("Dynamic (from Dropdown Box)", 'cost-calculator'); ?></option>
						</select>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends cost-calculator-payment-recurring-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] || $cost_calculator_payments_options["payment_recurring"]=="one_time" || $cost_calculator_payments_options["payment_recurring"]=="dynamic" ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="payment_recurring_interval">
							<?php esc_html_e("Recurring interval", "cost-calculator"); ?>
						</label>
					</th>
					<td>
						<select id="payment_recurring_interval" name="payment_recurring_interval">
							<option value="1"<?php echo (empty($cost_calculator_payments_options["payment_recurring_interval"]) || (int)$cost_calculator_payments_options["payment_recurring_interval"]==1 ? " selected='selected'" : ""); ?>><?php esc_html_e("every 1 period", 'cost-calculator'); ?></option>
							<option value="2"<?php echo ((int)$cost_calculator_payments_options["payment_recurring_interval"]==2 ? " selected='selected'" : ""); ?>><?php esc_html_e("every 2 periods", 'cost-calculator'); ?></option>
							<option value="3"<?php echo ((int)$cost_calculator_payments_options["payment_recurring_interval"]==3 ? " selected='selected'" : ""); ?>><?php esc_html_e("every 3 periods", 'cost-calculator'); ?></option>
							<option value="4"<?php echo ((int)$cost_calculator_payments_options["payment_recurring_interval"]==4 ? " selected='selected'" : ""); ?>><?php esc_html_e("every 4 periods", 'cost-calculator'); ?></option>
							<option value="5"<?php echo ((int)$cost_calculator_payments_options["payment_recurring_interval"]==5 ? " selected='selected'" : ""); ?>><?php esc_html_e("every 5 periods", 'cost-calculator'); ?></option>
							<option value="6"<?php echo ((int)$cost_calculator_payments_options["payment_recurring_interval"]==6 ? " selected='selected'" : ""); ?>><?php esc_html_e("every 6 periods", 'cost-calculator'); ?></option>
						</select>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends cost-calculator-payment-recurring-depends-dynamic<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] || $cost_calculator_payments_options["payment_recurring"]!="dynamic" ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="payment_recurring_field_name">
							<?php esc_html_e("Dropdown Box name", 'cost-calculator'); ?><a href="#" class="cost-calculator-help"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 496.158 496.158" xml:space="preserve"><path style="fill:#6E6E91;" d="M496.158,248.085c0-137.022-111.069-248.082-248.075-248.082C111.07,0.003,0,111.063,0,248.085	c0,137.001,111.07,248.07,248.083,248.07C385.089,496.155,496.158,385.086,496.158,248.085z"/><path style="fill:#FFFFFF;" d="M138.216,173.592c0-13.915,4.467-28.015,13.403-42.297c8.933-14.282,21.973-26.11,39.111-35.486 c17.139-9.373,37.134-14.062,59.985-14.062c21.238,0,39.99,3.921,56.25,11.755c16.26,7.838,28.818,18.495,37.683,31.97 c8.861,13.479,13.293,28.125,13.293,43.945c0,12.452-2.527,23.367-7.581,32.739c-5.054,9.376-11.062,17.469-18.018,24.279	c-6.959,6.812-19.446,18.275-37.463,34.388c-4.981,4.542-8.975,8.535-11.975,11.976c-3.004,3.443-5.239,6.592-6.702,9.447 c-1.466,2.857-2.603,5.713-3.406,8.57c-0.807,2.855-2.015,7.875-3.625,15.051c-2.784,15.236-11.501,22.852-26.147,22.852 c-7.618,0-14.028-2.489-19.226-7.471c-5.201-4.979-7.8-12.377-7.8-22.192c0-12.305,1.902-22.962,5.713-31.97	c3.808-9.01,8.861-16.92,15.161-23.73c6.296-6.812,14.794-14.904,25.488-24.28c9.373-8.202,16.15-14.392,20.325-18.567 c4.175-4.175,7.69-8.823,10.547-13.953c2.856-5.126,4.285-10.691,4.285-16.699c0-11.718-4.36-21.605-13.074-29.663 c-8.717-8.054-19.961-12.085-33.728-12.085c-16.116,0-27.981,4.065-35.596,12.195c-7.618,8.13-14.062,20.105-19.336,35.925 c-4.981,16.555-14.43,24.829-28.345,24.829c-8.206,0-15.127-2.891-20.764-8.679C141.035,186.593,138.216,180.331,138.216,173.592z M245.442,414.412c-8.937,0-16.737-2.895-23.401-8.68c-6.667-5.784-9.998-13.877-9.998-24.279c0-9.229,3.22-16.991,9.668-23.291 c6.444-6.297,14.354-9.448,23.73-9.448c9.229,0,16.991,3.151,23.291,9.448c6.296,6.3,9.448,14.062,9.448,23.291 c0,10.255-3.296,18.312-9.888,24.17C261.7,411.481,254.084,414.412,245.442,414.412z"/></svg></a>
						</label>
					</th>
					<td>
						<input type="text" class="regular-text input-full-width" value="<?php echo esc_attr($cost_calculator_payments_options["payment_recurring_field_name"]); ?>" id="payment_recurring_field_name" name="payment_recurring_field_name">
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="send_payment_email">
							<?php _e("Send payment confirmation email to admin", "cost-calculator"); ?>
						</label>
					</th>
					<td>
						<select id="send_payment_email" name="send_payment_email">
							<option value="1"<?php echo ((int)$cost_calculator_payments_options["send_payment_email"] ? " selected='selected'" : ""); ?>><?php _e("yes", 'cost-calculator'); ?></option>
							<option value="0"<?php echo (!(int)$cost_calculator_payments_options["send_payment_email"] ? " selected='selected'" : ""); ?>><?php _e("no", 'cost-calculator'); ?></option>
						</select>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="send_payment_email_client">
							<?php _e("Send payment confirmation email to client", "cost-calculator"); ?>
						</label>
					</th>
					<td>
						<select id="send_payment_email_client" name="send_payment_email_client">
							<option value="1"<?php echo ((int)$cost_calculator_payments_options["send_payment_email_client"] ? " selected='selected'" : ""); ?>><?php _e("yes", 'cost-calculator'); ?></option>
							<option value="0"<?php echo (!(int)$cost_calculator_payments_options["send_payment_email_client"] ? " selected='selected'" : ""); ?>><?php _e("no", 'cost-calculator'); ?></option>
						</select>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="payment_success_page">
							<?php _e("Payment success page", "cost-calculator"); ?>
						</label>
					</th>
					<td>
						<select id="payment_success_page" name="payment_success_page">
							<?php
							foreach($cost_calculator_pages_array as $key=>$value)
							{
								?>
								<option value="<?php echo esc_attr($value); ?>"<?php echo (isset($cost_calculator_payments_options["payment_success_page"]) && (int)$cost_calculator_payments_options["payment_success_page"]==(int)$value ? " selected='selected'" : ""); ?>><?php echo esc_html($key); ?></option>
								<?php
							}
							?>
						</select>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="payment_cancel_page">
							<?php _e("Payment cancel page", "cost-calculator"); ?>
						</label>
					</th>
					<td>
						<select id="payment_cancel_page" name="payment_cancel_page">
							<?php
							foreach($cost_calculator_pages_array as $key=>$value)
							{
								?>
								<option value="<?php echo esc_attr($value); ?>"<?php echo (isset($cost_calculator_payments_options["payment_cancel_page"]) && (int)$cost_calculator_payments_options["payment_cancel_page"]==(int)$value ? " selected='selected'" : ""); ?>><?php echo esc_html($key); ?></option>
								<?php
							}
							?>
						</select>
					</td>
				</tr>
				<tr valign="top" class="stripe-payments-enabled-depends<?php echo (!(int)$cost_calculator_payments_options["stripe_payments_enabled"] ? ' cost-calculator-hidden' : ''); ?>">
					<th scope="row">
						<label for="subscription_cancel_page">
							<?php _e("Subscription cancel page", "cost-calculator"); ?>
						</label>
					</th>
					<td>
						<select id="subscription_cancel_page" name="subscription_cancel_page">
							<?php
							foreach($cost_calculator_pages_array as $key=>$value)
							{
								?>
								<option value="<?php echo esc_attr($value); ?>"<?php echo (isset($cost_calculator_payments_options["subscription_cancel_page"]) && (int)$cost_calculator_payments_options["subscription_cancel_page"]==(int)$value ? " selected='selected'" : ""); ?>><?php echo esc_html($key); ?></option>
								<?php
							}
							?>
						</select>
					</td>
				</tr>
				<tr valign="top" class="no-border">
					<th colspan="2">
						<input type="submit" value="<?php esc_attr_e("Save Options", 'cost-calculator'); ?>" class="button-primary" name="submit">
						<input type="hidden" name="action" value="save">
					</th>
				</tr>
			</tbody>
		</table>
	</div>
</form>
<?php
require_once("help.php");
?>